<?php

namespace App\Entity;

use App\Repository\TypeSuiviRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: TypeSuiviRepository::class)]
class TypeSuivi
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $typesuivie = null;

    #[ORM\OneToMany(mappedBy: 'Typesuivi', targetEntity: Suivi::class)]
    private Collection $suivis;

    public function __construct()
    {
        $this->suivis = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTypesuivie(): ?string
    {
        return $this->typesuivie;
    }

    public function setTypesuivie(string $typesuivie): self
    {
        $this->typesuivie = $typesuivie;

        return $this;
    }
    public function __toString(): string
    {
        return $this->getTypesuivie();

    }

    /**
     * @return Collection<int, Suivi>
     */
    public function getSuivis(): Collection
    {
        return $this->suivis;
    }

    public function addSuivi(Suivi $suivi): self
    {
        if (!$this->suivis->contains($suivi)) {
            $this->suivis->add($suivi);
            $suivi->setTypesuivi($this);
        }

        return $this;
    }

    public function removeSuivi(Suivi $suivi): self
    {
        if ($this->suivis->removeElement($suivi)) {
            // set the owning side to null (unless already changed)
            if ($suivi->getTypesuivi() === $this) {
                $suivi->setTypesuivi(null);
            }
        }

        return $this;
    }
}
