<?php

namespace App\Form;

use App\Entity\Membre;
use App\Entity\Activite;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\HttpFoundation\RequestStack;
use Doctrine\Persistence\ManagerRegistry;

class ActiviteMembreType extends AbstractType
{
    private $requestStack;
    private $doctrine;

    public function __construct(RequestStack $requestStack,ManagerRegistry $doctrine)
    {
        $this->requestStack = $requestStack;
        $this->doctrine = $doctrine;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $membreid = $this->requestStack->getCurrentRequest()->query->get('id');
        $membre = $this->doctrine->getRepository(Membre::class)->findOneBy(['id' => $membreid]);

        $activite = new Activite();

        $builder
        
            ->add('activite', EntityType::class, [
                'label' => "Nom de l'activité",
                'label_attr' => ['class' => 'form-label'],
                'class' => Activite::class,
                'expanded' => true,
                'multiple' => true,
                'choice_label' => function (Activite $activite) {
                    return sprintf(' %s / %s / %s',$activite->getThemeactivite(), $activite->getNomactivite(), $activite->getTypeactivite());},
                
                'query_builder' => function (EntityRepository $er)use ($membre) {
                    if ($membre->getType() == 'parent') {
                        $trancheage = ['Adulte', '0-5 ans'];
                        return $er->createQueryBuilder('a')
                            ->where('a.inscription = :inscription')
                            ->andWhere('a.trancheage IN (:trancheage)')
                            ->setParameter('inscription', 'Ouverte')
                            ->setParameter('trancheage', $trancheage);
                    }
                    else{
                        $trancheage = ['0-5 ans','5-12 ans','12 ans et plus'];
                        return $er->createQueryBuilder('a')
                            ->where('a.inscription = :inscription')
                            ->andWhere('a.trancheage IN (:trancheage)')
                            ->setParameter('inscription', 'Ouverte')
                            ->setParameter('trancheage', $trancheage);
                    }
                },
                   
                'attr' =>['class' => 'mb-2 form-control form-control-solid ' ],
                
               
            ])
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        
        
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Membre::class,
        ]);
    }
}
