<?php

namespace App\Form;

use App\Entity\Activite;
use App\Entity\Programme;
use App\Entity\NomActivite;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

class ActiviteType extends AbstractType
{
    
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }
    
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {


        $builder
            ->add('Typeactivite',ChoiceType::class ,[
                'label' => "Présentiel/Virtuel",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'En virtuel' => 'En virtuel',
                    'En présentiel' => 'En présentiel',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('nomactivite', EntityType::class ,[
                'label' => "Type de l'activité",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'class' => NomActivite::class,
                'choice_label' =>'nom',
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'style' => 'height: 40px;'
                ],
               
            ])
            ->add('trancheage',ChoiceType::class ,[
                'label' => "Tranche d'âge",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    '0-5 ans' => '0-5 ans',
                    '5-12 ans' => '5-12 ans',
                    '12 ans et plus'=> '12 ans et plus',
                    'Adulte'=> 'Adulte',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            
            
            ->add('themeactivite', TextType::class ,[
                'label' => "Thème de l'activité",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Thème de l'activité",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('objectifactivite', TextareaType::class ,[
                'label' => "Objectif de l'activité",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Objectif de l'activité",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('impactactivite', TextareaType::class ,[
                'label' => "Impact de l'activité",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Impact de l'activité",
                    'class'=> 'form-control form-control-solid',
                ]
            ]) 
            ->add('programmeid', ChoiceType::class, [
                'label' => 'Sélectionner un programme', 
                'label_attr' => ['class' => 'form-label'],
                'choices' => $this->getProgrammeChoices(), 
                'placeholder' => 'Choisir un programme', 
                'required' => false, 
                'mapped' => false,
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'style' => 'height: 40px;'
                ],
            ])
            ->add('inscription',ChoiceType::class ,[
                'label' => "Inscription",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Ouverte' => 'Ouverte',
                    'Fermée' => 'Fermée',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Activite::class,
        ]);
    }

    private function getProgrammeChoices()
{
    // récupérer la liste des programmes depuis la base de données
    $programmes = $this->entityManager->getRepository(Programme::class)->findAll();

    // transformer la liste des programmes en un tableau associatif utilisable par le champ ChoiceType
    $choices = [];
    foreach ($programmes as $programme) {
        $choices[$programme->getNom()] = $programme->getId();
    }

    return $choices;
}
}
