<?php

namespace App\Form;

use App\Entity\Anneescolaire;
use App\Entity\Ecole;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;


class AnneescolaireType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('anneescolaire',TextType::class ,[
                'label' => "Année scolaire",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Année scolaire",
                    'class'=> 'form-control form-control-solid',
                ],
                //'row_attr' => ['class' => 'flex-row-fluid']
            ])
            ->add('nomecole', EntityType::class ,[
                'label' => "Nom école",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
                'class' => Ecole::class,
                'choice_label' =>'nom',
                'attr' =>['class' => 'form-select mb-2 form-control form-control-solid', 'id' =>'kt_ecommerce_edit_order_shipping_2'],
                
                //'row_attr' => ['class' => 'flex-row-fluid']
                //'mapped' => false,
               
            ])
            ->add('nomenseignant',TextType::class ,[
                'label' => "Nom enseignant",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom enseignant",
                    'class'=> 'form-control form-control-solid',
                ]
                ,
            //'row_attr' => ['class' => 'flex-row-fluid']
            ])
            ->add('emailenseignant',TextType::class ,[
                'label' => "Email enseignant",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Email enseignant",
                    'class'=> 'form-control form-control-solid',
                ]
                ,
            //'row_attr' => ['class' => 'flex-row-fluid']
            ])
            ->add('niveauscolaire',ChoiceType::class ,[
                'label' => "Niveau Scolaire",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'choices'  => [
                    'Maternelle' => 'Maternelle',
                    '2ème année primaire' => '2ème année primaire',
                    '3ème année primaire' => '3ème année primaire',
                    '4ème année primaire' => '4ème année primaire',
                    '5ème année primaire' => '5ème année primaire',
                    '6ème année primaire' => '6ème année primaire',

                    '1er année secondaire' => '1er année secondaire',
                    '2ème année secondaire' => '2ème année secondaire',
                    '3ème année secondaire' => '3ème année secondaire',
                    '4ème année secondaire' => '4ème année secondaire',
                    '5ème année secondaire' => '5ème année secondaire',
                ],

                'attr' =>['class' => 'form-select mb-2 form-control form-control-solid', 'id' =>'kt_ecommerce_edit_order_shipping'],
                'choice_attr' =>['class' => 'form-select mb-2 form-control form-control-solid', 'id' =>'kt_ecommerce_edit_order_shipping'],
                
                //'row_attr' => ['class' => 'flex-row-fluid']
            ]);

        
        
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Anneescolaire::class,
        ]);
    }
}
