<?php

namespace App\Form;

use App\Entity\Ecole;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;

class EcoleType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
        ->add('nom', TextType::class ,[
            'label' => "Nom école",
            'label_attr' => ['class' => 'required form-label'],
           
            'attr' => [
                'placeholder' => "Nom école",
                'class'=> 'form-control form-control-solid',
            ]
        ])
           
                
        ->add('Enregistrer', SubmitType::class,[
            'attr'=> [
                'class'=> 'btn btn-primary',
        ]
            ])
            ->setMethod('GET','POST')
              
            ->getForm();
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Ecole::class,
        ]);
    }
}
