<?php

namespace App\Form;

use App\Entity\Freresoeur;
use App\Form\DataTransformer\FrSrTransformer;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

use Symfony\Component\Form\FormTypeInterface;

class FreresSoeursType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
        ->add('nom',TextType::class ,[
            'label' => "Nom",
            'label_attr' => ['class' => 'form-label'],
            'required'   => true,
            'row_attr' => ['class' => 'flex-row-fluid'],
            
           
            'attr' => [
                'placeholder' => "Nom",
                'class'=> 'form-control form-control-solid',
                
            ]
        ])
        ->add('prenom',TextType::class ,[
            'label' => "Prénom",
            'label_attr' => ['class' => 'form-label'],
            'required'   => true,
           
            'attr' => [
                'placeholder' => "Prénom",
                'class'=> 'form-control form-control-solid',
            ],
            'row_attr' => ['class' => 'flex-row-fluid']
        ])
        ->add('sexe',ChoiceType::class ,[
            'label' => "Sexe",
            'label_attr' => ['class' => 'form-label'],
            'required'   => false,
            'choices'  => [
                'Masculin' => 'Masculin',
                'Féminin' => 'Féminin',
            ],
            'attr' =>['class' => 'form-select mb-2 form-control form-control-solid', 'id' =>'kt_ecommerce_edit_order_shipping'],
            'row_attr' => ['class' => 'flex-row-fluid']
        ])
        ->add('age',TextType::class ,[
            'label' => "Âge",
            'label_attr' => ['class' => 'form-label'],
            'required'   => false,
           
            'attr' => [
                'placeholder' => "Âge",
                'class'=> 'form-control form-control-solid',
            ],
            'row_attr' => ['class' => 'flex-row-fluid']
        ]);
        

            
           //->setMethod('GET','POST')
              
            //->getForm();
          
        
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Freresoeur::class,
        ]);
    }
}
