<?php

namespace App\Form;

use App\Entity\Habitation;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;

class HabitationType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
        ->add('lieu', TextType::class ,[
            'label' => "Type d'habitation",
            'label_attr' => ['class' => 'required form-label'],
           
            'attr' => [
                'placeholder' => "type d'habitation",
                'class'=> 'form-control form-control-solid',
            ]
        ])
           
                
        ->add('Enregistrer', SubmitType::class,[
            'attr'=> [
                'class'=> 'btn btn-primary',
        ]
            ])
            ->setMethod('GET','POST')
              
            ->getForm();
        
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Habitation::class,
        ]);
    }
}
