<?php

namespace App\Form;

use App\Entity\Jeunes;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;

class JeunesType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom',TextType::class ,[
                'label' => "Nom du jeune",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
                'row_attr' => ['class' => 'flex-row-fluid'],
                
               
                'attr' => [
                    'placeholder' => "Nom du jeune",
                    'class'=> 'form-control form-control-solid',
                    
                ]
            ])
            ->add('prenom',TextType::class ,[
                'label' => "Prénom du jeune",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
                'row_attr' => ['class' => 'flex-row-fluid'],
                
               
                'attr' => [
                    'placeholder' => "Prénom du jeune",
                    'class'=> 'form-control form-control-solid',
                    
                ]
            ])
            ->add('datenaissance',DateType::class ,[
                'label' => "Date de naissance",
                'label_attr' => ['class' => 'required form-label'],
                'format' => 'yyyy-MM-dd',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2', 'id' => 'kt_ecommerce_edit_order_date'],
            ])
           
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Jeunes::class,
        ]);
    }
}
