<?php

namespace App\Form;

use App\Entity\Membre;
use DateTime;
use App\Entity\Seance;
use Doctrine\ORM\EntityRepository;
use App\Entity\MembreSeanceSuiviEns;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\HttpFoundation\RequestStack;
use Doctrine\Persistence\ManagerRegistry;

class MembreSeanceSuivType extends AbstractType
{
    private $requestStack;
    private $doctrine;

    public function __construct(RequestStack $requestStack,ManagerRegistry $doctrine)
    {
        $this->requestStack = $requestStack;
        $this->doctrine = $doctrine;
    }
    

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $dateNow = new DateTime();
            $membreid = $this->requestStack->getCurrentRequest()->query->get('id');
            $membre = $this->doctrine->getRepository(Membre::class)->findOneBy(['id' => $membreid]);

            $builder
                
                ->add('Seance', EntityType::class, [
                    'label' => "Choisir une séance",
                    'label_attr' => ['class' => 'form-label'],
                    'multiple' => false,
                    'expanded' => true,
                    'class' => Seance::class,
                    'query_builder' => function (EntityRepository $er) use ($dateNow, $membre) {
                        if ($membre->getType() == 'parent') {
                            return $er->createQueryBuilder('seance')
                                //->join('s.sessions', 'session')
                                //->where('session.datefin > :dateNow')
                                ->join('seance.sessions', 'session')
                                ->join('session.programme', 'programme')
                                ->where('session.datefin > :dateNow')
                                ->andWhere('programme.trancheage IN (:trancheage)')
                                ->setParameter('dateNow', $dateNow)
                                ->setParameter('trancheage', [1, 4]);
                            }
                        else{
                            
                            //dump($membre->getType()).die();
                            return $er->createQueryBuilder('seance')
                                //->join('s.sessions', 'session')
                                //->where('session.datefin > :dateNow')
                                ->join('seance.sessions', 'session')
                                ->join('session.programme', 'programme')
                                ->where('session.datefin > :dateNow')
                                ->andWhere('programme.trancheage IN (:trancheage)')
                                ->setParameter('dateNow', $dateNow)
                                ->setParameter('trancheage', [1, 2, 3]);

                        }
                    },
                'choice_label' => function (Seance $seance) { 
                    if ($seance->getSessions()->getProgramme()->getNom() == 'NDPS') {
                        $semainendps = implode(',', $seance->getSemainendps());
                        return sprintf('%s -> %s -> %s le %s à %s h', $seance->getSessions()->getNom(), $seance->getSessions()->getProgramme()->getNom(), $seance->getNom(), $semainendps, $seance->getHeuredebut()->format('H:i'));
                    }
                    else{
                    return sprintf('%s -> %s -> %s le %s à %s h', $seance->getSessions()->getNom(), $seance->getSessions()->getProgramme()->getNom(), $seance->getNom(), $seance->getJour(), $seance->getHeuredebut()->format('H:i'));
                    }
                },
                
                'attr' =>['
                    class' => 'mb-2 form-control form-control-solid'
                ],
                'choice_attr' => function($choice, $key, $value) {
                    return ['class' => 'form-check', 'style' => 'display:inherit;margin-right:5px;'];
                },
                
               
            ])
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => MembreSeanceSuiviEns::class,
        ]);
    }
}
