<?php

namespace App\Form;

use App\Entity\Langue;
use App\Entity\Membre;
use App\Entity\Session;
use App\Entity\Organisme;
use App\Entity\Habitation;
use App\Entity\MembreSession;
use App\Entity\Projet;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\CountryType; 
use Symfony\Component\Form\Extension\Core\Type\CollectionType;



class MembreType extends AbstractType

{
    

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        

        $builder
            ->add('nom', TextType::class ,[
                'label' => "Nom enfant",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom enfant",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('prenom',TextType::class ,[
                'label' => "Prénom enfant",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Prénom enfant",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('datenaissance',DateType::class ,[
                'label' => "Date de naissance",
                'label_attr' => ['class' => 'required form-label'],
                'format' => 'yyyy-MM-dd',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid',
                'placeholder' => "Date de naissance"],
            ])
            ->add('sexe',ChoiceType::class ,[
                'label' => "Sexe",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Masculin' => 'Masculin',
                    'Féminin' => 'Féminin',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('paysorigine', CountryType::class,[
                'label' => "Pays d'origine",
                'label_attr' => ['class' => 'required form-label'],
                //'data' => 'CA',
                'data' => $options['entity'] ? $options['entity']->getPaysOrigine() : 'CA',
                'required'   => true,
                'attr' => [
                    'class' => 'form-select form-control form-control-solid selection',
                    'style' => 'height: 40px;'],
            ])
            ->add('langue', EntityType::class ,[
                'label' => "Langue",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'class' => Langue::class,
                'choice_label' =>'langue',
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('habitation', EntityType::class ,[
                'label' => "Type d'habitation",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'class' => Habitation::class,
                'choice_label' =>'lieu',
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
               
            ])
            ->add('allergie',TextType::class ,[
                'label' => "Allergie",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
               
                'attr' => [
                    'placeholder' => "Allergie",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('reference', EntityType::class ,[
                'label' => "Référence",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'class' => Organisme::class,
                'choice_label' =>'nom',
                'attr' => [
                    'placeholder' => "Référence",
                    'class' => 'form-select form-control form-control-solid selection',
                    'style' => 'height: 40px;'
                ],
               
            ])
            ->add('nomintervenant',TextType::class ,[
                'label' => "Référent",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
               
                'attr' => [
                    'placeholder' => "Référent",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
                ->add('parent', EntityType::class, [
                    'label' => "Nom du parent",
                    'label_attr' => ['class' => 'form-label'],
                    'class' => Membre::class,
                    'expanded'=> false,
                    'multiple' => false,
                    'attr' => [
                        'class' => 'form-select form-control form-control-solid selection',
                        'style' => 'height: 40px;'
                    ],
                    'choice_label' => function (Membre $parent) {
                        return sprintf(' %s %s /  %s', $parent->getNom(), $parent->getPrenom(), $parent->getCourriel());},
                       
                    //'attr' =>['class' => 'form-select mb-2 form-control form-control-solid', 'id' =>'kt_ecommerce_edit_order_payment'],
                    'query_builder' => function (EntityRepository $er) {
                        return $er->createQueryBuilder('m')
                            ->where('m.type = :type')
                            ->setParameter('type', 'parent');
                    },
                    
                   
                ])
                
           
            ->add('nbrfrsr',TextType::class ,[
                'label' => "Nombre frères et soeurs",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
               
                'attr' => [
                    'placeholder' => "Nombre",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
        
            ->add('AnneesScolaires', CollectionType::class, [
                'entry_type' => AnneescolaireType::class,
                'entry_options' => [
                    'label' => false
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'label' => ' ',
                'required'   => false,
                
                
                ])
            
            ->add('freressoeurs', CollectionType::class, [
                'entry_type' => FreresSoeursType::class,
                'entry_options' => [
                    'label' => false
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'label' => ' ',
                'required'   => false,
                
                
                ])

                ->add('projet', EntityType::class ,[
                    'label' => "Nom du projet",
                    'label_attr' => ['class' => 'form-label'],
                    'required'   => true,
                    'class' => Projet::class,
                    'expanded' => true,
                    'multiple' => true,
                    'choice_label' =>'nomprojet',
                    'attr' =>['
                        class' => 'form-control form-control-solid'],
                   
                ])
                

            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ]);
                
              
        
    }
    
    

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Membre::class,
            'query_builder' => null,
            // add an option to pass the current entity instance to the form
            'entity' => null
            
            
        ]);
    }
    public function getBlockPrefix()
    {
        return 'MembreType';
    }

    
   

   
}
