<?php

namespace App\Form;

use App\Entity\NomActivite;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;

class NomActiviteType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            
        ->add('nom', TextType::class ,[
            'label' => "Type de l'activité",
            'label_attr' => ['class' => 'required form-label'],
           
            'attr' => [
                'placeholder' => "Type de l'activité",
                'class'=> 'form-control form-control-solid',
            ]
        ])
           
                
        ->add('Enregistrer', SubmitType::class,[
            'attr'=> [
                'class'=> 'btn btn-primary',
        ]
            ])
            ->setMethod('GET','POST')
              
            ->getForm();
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => NomActivite::class,
        ]);
    }
}
