<?php

namespace App\Form;

use App\Entity\Membre;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use App\Entity\Habitation;
use App\Entity\Langue;
use App\Entity\Organisme;
use App\Entity\Projet;
use App\Entity\Session;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CountryType; 
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;

class ParentsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom', TextType::class ,[
                'label' => "Nom",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('prenom', TextType::class ,[
                'label' => "Prénom",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Prénom",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            
            ->add('sexe',ChoiceType::class ,[
                'label' => "Sexe",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Masculin' => 'Masculin',
                    'Féminin' => 'Féminin',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('datenaissance',DateType::class ,[
                'label' => "Date de naissance",
                'label_attr' => ['class' => 'form-label'],
                'format' => 'yyyy-MM-dd',
                'widget' => 'single_text',
                'required'   => false,
                'attr' => ['class' => 'form-control mb-2 form-control-solid',
                'placeholder' => "Date de naissance",],
            ])
            ->add('paysorigine', CountryType::class,[
                'label' => "Pays d'origine",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                //'data' => 'CA',
                'data' => $options['entity'] ? $options['entity']->getPaysOrigine() : 'CA',
                'attr' => [
                    'class' => 'form-select form-control form-control-solid selection',
                    'style' => 'height: 40px;'],
            ])
            ->add('Langue', EntityType::class ,[
                'label' => "Langue",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'class' => Langue::class,
                'choice_label' =>'langue',
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('habitation', EntityType::class ,[
                'label' => "Type d'habitation",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'class' => Habitation::class,
                'choice_label' =>'lieu',
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
           
            ->add('courriel',EmailType::class ,[
                'label' => "Email",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
               
                'attr' => [
                    'placeholder' => "Email",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('telephone',TextType::class ,[
                'label' => "Téléphone",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
               
                'attr' => [
                    'placeholder' => "Téléphone",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('adresse',TextType::class ,[
                'label' => "Adresse",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
               
                'attr' => [
                    'placeholder' => "Adresse",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('monoparental',ChoiceType::class ,[
                'label' => "Monoparental",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'choices'  => [
                    'Oui' => 'Oui',
                    'Non' => 'Non',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('statutoccupation',ChoiceType::class ,[
                'label' => "Statut d'occupation",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'choices'  => [
                    'Proprietaire' => 'Proprietaire',
                    'Locataire' => 'Locataire',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('Emploi',ChoiceType::class ,[
                'label' => "Avez-vous un emploi?",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'choices'  => [
                    'Oui' => 'Oui',
                    'Non' => 'Non',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('revenuefamiliale',TextType::class ,[
                'label' => "Revenue familiale",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
               
                'attr' => [
                    'placeholder' => "Revenue familiale",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('nbrjeunes',NumberType::class ,[
                'label' => "Nombre des enfants",
                
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'attr' => [
                    'min' => 0,
                    'max' => 100,
                ],
               
                'attr' => [
                    'placeholder' => "Nombre des enfants",
                    'class'=> 'form-control form-control-solid',
                ]
            ])

            ->add('projet', EntityType::class ,[
                'label' => "Nom du projet",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
                'class' => Projet::class,
                'expanded' => true,
                'multiple' => true,
                'choice_label' =>'nomprojet',
                'attr' =>['
                    class' => 'form-control form-control-solid'],
               
            ])

            
                

               

            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ]);
            
           
           
           
        
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Membre::class,
             // add an option to pass the current entity instance to the form
             'entity' => null
        ]);
    }

    public function getBlockPrefix()
    {
        return 'ParentsType';
    }
}
