<?php

namespace App\Form;

use App\Entity\Programme;
use App\Entity\TrancheAge;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

class ProgrammeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom', TextType::class ,[
                'label' => "Nom du programme",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom du programme",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('trancheage', EntityType::class ,[
                'label' => "Tranche d'âge",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'class' => TrancheAge::class,
                'choice_label' =>'trancheage',
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('description', TextareaType::class, [
                'label' => "Description",
                'label_attr' => ['class' => 'required form-label'],
                'required' => true,
                'attr' => [
                    'placeholder' => "Ajouter une description du programme",
                    'rows' => 4,
                    'class' => 'form-control form-control-solid'
                ],
            ])
           
            ->add('seance',ChoiceType::class ,[
                'label' => "Séance",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Oui' => 'Oui',
                    'Non' => 'Non',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])

            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
            
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Programme::class,
        ]);
    }
}
