<?php

namespace App\Form;

use App\Entity\Seance;
use App\Entity\SeanceDetail;
use DateTime;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;

class SeanceDetailType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('effectue',ChoiceType::class ,[
                'label' => "Effectuée",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Oui' => 'Oui',
                    'Non' => 'Non',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('seance', EntityType::class ,[
                'label' => "Nom du groupe",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'class' => Seance::class,
                //'choice_label' =>'nom',
                'choice_label' => function (Seance $seance) { 
                    return sprintf('Programme: %s -> Session: %s -> Séance: %s ', $seance->getSessions()->getProgramme()->getNom(),$seance->getSessions()->getNom(), $seance->getNom());
                
                },
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                'style' => 'height: 40px;'
                ],
            ])
            ->add('dateseance', DateType::class ,[
                'label' => "Date de la séance",
                'label_attr' => ['class' => 'required form-label'],
                'format' => 'yyyy-MM-dd',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid', 'id' => 'kt_ecommerce_edit_order_date'],
            ])
            ->add('datesemaine', DateType::class ,[
                'label' => "Date de la semaine",
                'label_attr' => ['class' => 'form-label'],
                'format' => 'yyyy-MM-dd',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid', 'id' => 'kt_ecommerce_edit_order_date'],
            ])
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => SeanceDetail::class,
        ]);
    }
}
