<?php

namespace App\Form;

use App\Entity\Programme;
use App\Entity\Seance;
use App\Entity\Session;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class SeanceType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom', TextType::class ,[
                'label' => "Nom du groupe",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom du groupe",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('jour', ChoiceType::class, [
                'label' => 'Jour',
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'choices' => [
                    'Lundi' => 'lundi',
                    'Mardi' => 'mardi',
                    'Mercredi' => 'mercredi',
                    'Jeudi' => 'jeudi',
                    'Vendredi' => 'vendredi',
                    'Samedi' => 'samedi',
                    'Dimanche' => 'vendredi',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('heuredebut', TimeType::class, [
                'label' => 'Heure de début',
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'widget' => 'choice', // afficher les menus déroulants pour sélectionner l'heure
                'minutes' => [0, 15, 30, 45], // afficher des minutes spécifiques dans les menus déroulants
                'attr' => [
                    'placeholder' => "Heure de début",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('heurefin',TimeType::class, [
                'label' => 'Heure de fin',
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'widget' => 'choice', // afficher les menus déroulants pour sélectionner l'heure
                'minutes' => [0, 15, 30, 45], // afficher des minutes spécifiques dans les menus déroulants
                'attr' => [
                    'placeholder' => "Heure de fin",
                    'class'=> 'form-control form-control-solid',
                    // Add classes to the input element
                ],
                
                
            ])
            ->add('typeseance',ChoiceType::class ,[
                'label' => "Type du groupe",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Présentiel' => 'Présentiel',
                    'En ligne' => 'En ligne',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('sessions', EntityType::class ,[
                'label' => "Nom de la session",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'class' => Session::class,
                'choice_label' => function (Session $session) { 
                        return sprintf('Programme: %s -> Session: %s ', $session->getProgramme()->getNom(), $session->getNom());
                    
                },
                
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
               
            ])
            ->add('semainendps', ChoiceType::class, [
                'label' => 'Les jours du programme NDPS',
                'label_attr' => ['class' => 'form-label '],
                'required'   => false,
                'choices' => [
                    'Lundi' => 'lundi',
                    'Mardi' => 'mardi',
                    'Mercredi' => 'mercredi',
                    'Jeudi' => 'jeudi',
                    'Vendredi' => 'vendredi',
                    'Samedi' => 'samedi',
                    'Dimanche' => 'vendredi',
                    
                ],
                'multiple' => true,
                'expanded' => true,
                'attr' =>[
                    'class'=> 'form-control form-control-solid',
                    
                ],
                'choice_attr' => [
                    'lundi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:20px;margin-left:10px;'],
                    'mardi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:20px;'],
                    'mercredi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:20px;'],
                    'jeudi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:20px;'],
                    'vendredi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:20px;'],
                    'samedi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:20px;'],
                    'dimanche' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:20px;'],

                    'Lundi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:2px;margin-left:10px;'],
                    'Mardi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:2px;margin-left:10px;'],
                    'Mercredi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:2px;margin-left:10px;'],
                    'Jeudi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:2px;margin-left:10px;'],
                    'Vendredi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:2px;margin-left:10px;'],
                    'Samedi' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:2px;margin-left:10px;'],
                    'Dimanche' => ['class' => 'form-check-input','style' => 'display:inline-block;margin-right:2px;margin-left:10px;'],
                     // Ajoute un style CSS à l'option 2
                ] ,
               
               
              
            ])

            

           

            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Seance::class,
        ]);
    }
}
