<?php

namespace App\Form;

use App\Entity\Programme;
use App\Entity\Seance;
use App\Entity\Session;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

class SessionType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom' ,TextType::class ,[
                'label' => "Nom de la session",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom de la session",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('description', TextareaType::class, [
                'label' => "Description",
                'label_attr' => ['class' => 'required form-label'],
                'required' => true,
                'attr' => [
                    'placeholder' => "Ajouter une description de la session",
                    'rows' => 4,
                    'class' => 'form-control form-control-solid'
                ],
            ])
            ->add('datedebut',DateType::class ,[
                'label' => "Date de début",
                'label_attr' => ['class' => 'required form-label'],
                'format' => 'yyyy-MM-dd',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid',
                    'placeholder' => "Date de début"],
            ])
            ->add('datefin',DateType::class ,[
                'label' => "Date de fin",
                'label_attr' => ['class' => 'required form-label'],
                'format' => 'yyyy-MM-dd',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid',
                    'placeholder' => "Date de fin"],
            ])

            ->add('nbrmaxparticipants' ,TextType::class ,[
                'label' => "Nombre maximum des participants",
                'label_attr' => ['class' => 'form-label'],
                'required'   => false,
                'attr' => [
                    'placeholder' => "Nombre maximum des participants",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('programme', EntityType::class ,[
                'label' => "Nom du programme",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'class' => Programme::class,
                'choice_label' =>'nom',
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
               
            ])

            

            
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
            
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Session::class,
        ]);
    }
}
