<?php

namespace App\Form;

use DateTime;
use App\Entity\Suivi;
use App\Entity\Membre;
use App\Entity\TypeSuivi;
use App\Entity\User;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Validator\Constraints\File;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\DateIntervalType;

class SuiviFormType extends AbstractType
{
    private $requestStack;

    public function __construct(RequestStack $requestStack)
    {
        $this->requestStack = $requestStack;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $participantNom = $this->requestStack->getCurrentRequest()->query->get('participantNom');

        $builder
            ->add('Dateintervention', DateType::class, [
                'data' => new DateTime(),
                'label_attr' => ['class' => 'required form-label'],
                'label' => "Date de l'intervention",
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid', 'id' => 'kt_ecommerce_edit_order_date'],
            ])
            ->add('dureeintervention', DateIntervalType::class, [
                'label' => "Durée de l'intervention",
                'widget' => 'choice',
                'label_attr' => ['class' => 'required form-label'],
                'with_years' => false,
                'with_months' => false,
                'with_days' => false,
                'with_hours' => true,
                'with_minutes' => true,
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid'],
                
            ])
            ->add('raison',TextType::class ,[
                'label' => "Raison de l'intervention",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Raison de l'intervention",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            
            ->add('intervenant',EntityType::class ,[
                'label' => "Nom de l'intervenant",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
                'class' => User::class,
                'choice_label' => 'nom',
                'attr' => [
                    'placeholder' => "Nom de l'intervenant",
                    'class' => 'form-select form-control form-control-solid selection'
                ],
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('u')
                    ->where('u.role IN (:roles)')
                    ->setParameter('roles', ['Intervenant', 'Intervenant Psychosocial']);
                },
               
            ])
            ->add('note', TextareaType::class, [
                'label' => "Notes",
                'label_attr' => ['class' => 'form-label'],
                'required' => false,
                'attr' => [
                    'placeholder' => "Ajouter une note",
                    'rows' => 3,
                    'class' => 'form-control form-control-solid'
                ],
            ])
        
            ->add('fichesuivi', FileType::class, [
                'label' => 'Fiche suivie (PDF file)',
                'mapped' => false,
                'required' => false,
                'constraints' => [
                    new File([
                        'maxSize' => '1024k',
                        'mimeTypes' => [
                            'application/pdf',
                            'application/x-pdf',
                        ],
                        'mimeTypesMessage' => 'Please upload a valid PDF document',
                    ])
                ],
                'label_attr' => ['class' => 'form-label'],
                'attr' => [
                    'placeholder' => "Ajouter une fiche de suivie",
                    'rows' => 4,
                    'class' => 'form-control form-control-solid'
                ],
                ])
            ->add('nommembre',TextType::class ,[
                'label' => "Nom du participant",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'data' => $participantNom,

                'disabled' => true,
               
                'attr' => [
                    'placeholder' => "Nom du participant",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            ->add('Typesuivi', EntityType::class ,[
                'label' => "Type de suivi",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
                'class' => TypeSuivi::class,
                'choice_label' => 'typesuivie',
                'attr' => [
                    'placeholder' => "Matière",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
               
            ])
            ->add('suivipar',ChoiceType::class ,[
                'label' => "Suivi",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Par téléphone' => 'Par téléphone',
                    'Via zoom' => 'Via zoom',
                    'En présentiel' => 'En présentiel',
                    'À domicile' => 'À domicile',
                    
                ],
                'attr' => [
                    'placeholder' => "Matière",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        ;
    }
    

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Suivi::class,
        ]);
    }
}
