<?php

namespace App\Form;

use App\Entity\MembreSeance;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use App\Entity\SuivieEnseignement;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Validator\Constraints\File;

class SuivieEnseignementAADLType extends AbstractType
{
    private $requestStack;

    public function __construct(RequestStack $requestStack)
    {
        $this->requestStack = $requestStack;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $seanceNom = $this->requestStack->getCurrentRequest()->query->get('seanceNom');
        $participantNom = $this->requestStack->getCurrentRequest()->query->get('participantNom');
        $builder
            ->add('datesuivie', DateType::class, [
                'data' => new \DateTime(),
                'label_attr' => ['class' => 'required form-label'],
                'label' => 'Date du suivi',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control mb-2 form-control-solid',
                    'placeholder' => "Date de naissance"],
            ])
            ->add('nomprogramme',TextType::class ,[
                'label' => "Nom du programme",
                'disabled' => true,
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom du programme",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            ->add('presence',ChoiceType::class ,[
                'label' => "Présence",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Présent(e)' => 'Présent(e)',
                    'Absent(e)' => 'Absent(e)',
                    
                ],
                'attr' => [
                    'placeholder' => "Présence",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('nomseance',TextType::class ,[
                'label' => "Nom de la séance",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'data' => $seanceNom,
                'disabled' => true,
               
                'attr' => [
                    'placeholder' => "Nom de la séance",
                    'class'=> 'form-control form-control-solid',
                ]
                ])

           
            ->add('matiere',ChoiceType::class ,[
                'label' => "Matière",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Lecture' => 'Lecture',
                    'Conjugaison' => 'Conjugaison',
                    'Ecriture' => 'Ecriture',
                    'Dictée' => 'Dictée',
                    'Autre' => 'Autre',
                    
                ],
                'attr' => [
                    'placeholder' => "Matière",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('nomenfant',TextType::class ,[
                'label' => "Nom de l'enfant",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'data' => $participantNom,

                'disabled' => true,
               
                'attr' => [
                    'placeholder' => "Nom du de l'enfant",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            ->add('nomtuteur',TextType::class ,[
                'label' => "Nom de l'intervenant",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom de l'intervenant",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            ->add('travail',ChoiceType::class ,[
                'label' => "Travail",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Bien fait' => 'Bien fait',
                    'Éprouve des difficultés' => 'Éprouve des difficultés',
                    'Doit terminer le travail à la maison' => 'Doit terminer le travail à la maison',
                    'Matériels oubliés' => 'Matériels oubliés',
                    'Pas de devoirs' => 'Pas de devoirs',
                    'Exercices de renforcement' => 'Exercices de renforcement',
                ],
                'attr' => [
                    'placeholder' => "Travail",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('descriptiontravail', TextareaType::class, [
                'label' => "Description du travail",
                'label_attr' => ['class' => 'form-label'],
                'required' => false,
                'attr' => [
                    'placeholder' => "Ajouter une description du travail",
                    'rows' => 3,
                    'class' => 'form-control form-control-solid'
                ],
            ])
            ->add('comportement',ChoiceType::class ,[
                'label' => "Comportement",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Rien à signaler' => 'Rien à signaler',
                    'Plus ou moins concentré(e)' => 'Plus ou moins concentré(e)',
                    'Problème de concentration ' => 'Problème de concentration ',
                    'Maussade / Fatigué(e)' => 'Maussade / Fatigué(e)',
                    'Agité(e) / Agressif(ve)' => 'Agité(e) / Agressif(ve)',
                    'Ne collabore pas/ne participe pas' => 'Ne collabore pas/ne participe pas',
                    'Appel à la maison' => 'Appel à la maison',
                    'Prévoir rencontre avec parent' => 'Prévoir rencontre avec parent',
                ],
                'attr' => [
                    'placeholder' => "Présence",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            
            ->add('fichesuivie', FileType::class, [
                'label' => 'Fiche suivie (PDF file)',
                'mapped' => false,
                'required' => false,
                'constraints' => [
                    new File([
                        'maxSize' => '1024k',
                        'mimeTypes' => [
                            'application/pdf',
                            'application/x-pdf',
                        ],
                        'mimeTypesMessage' => 'Please upload a valid PDF document',
                    ])
                ],
                'label_attr' => ['class' => 'form-label'],
                'attr' => [
                    'placeholder' => "Ajouter une fiche de suivie",
                    'rows' => 4,
                    'class' => 'form-control form-control-solid'
                ],
                ])
        
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ]);
        
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => SuivieEnseignement::class,
            'seance_nom' => null,
            'participantNom' => null,
        ]);
    }
}
