<?php

namespace App\Form;

use App\Entity\SuivieEnseignement;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Validator\Constraints\File;

class SuivieEnseignementNDPSType extends AbstractType
{
    private $requestStack;

    public function __construct(RequestStack $requestStack)
    {
        $this->requestStack = $requestStack;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $seanceNom = $this->requestStack->getCurrentRequest()->query->get('seanceNom');
        $participantNom = $this->requestStack->getCurrentRequest()->query->get('participantNom');

        $builder
            ->add('datesuivie', DateType::class, [
                'data' => new \DateTime(),
                'label_attr' => ['class' => 'required form-label'],
                'label' => 'Date du suivi',
                'widget' => 'single_text',
                'required'   => true,
                'attr' => ['class' => 'form-control form-control-solid mb-2', 'id' => 'kt_ecommerce_edit_order_date'],
            ])
            ->add('nomprogramme',TextType::class ,[
                'label' => "Nom du programme",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                

                'disabled' => true,
               
                'attr' => [
                    'placeholder' => "Nom du programme",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            
            ->add('nomseance',TextType::class ,[
                'label' => "Nom de la séance",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'data' => $seanceNom,

                'disabled' => true,
               
                'attr' => [
                    'placeholder' => "Nom de la séance",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            ->add('nomenfant',TextType::class ,[
                'label' => "Nom de l'enfant",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'data' => $participantNom,

                'disabled' => true,
               
                'attr' => [
                    'placeholder' => "Nom de l'enfant",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            ->add('nomtuteur',TextType::class ,[
                'label' => "Nom de l'intervenant",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nom de l'intervenant",
                    'class'=> 'form-control form-control-solid',
                ]
                ])

                ->add('thematique',TextType::class ,[
                    'label' => "Thématique",
                    'label_attr' => ['class' => 'required form-label'],
                    'required'   => true,
                    'attr' => [
                        'placeholder' => "Thématique",
                        'class'=> 'form-control form-control-solid',
                    ]
                ])

                
            ->add('commentaireintervenant', TextareaType::class, [
                'label' => "Commentaire de l'intervenant(e)",
                'label_attr' => ['class' => 'form-label'],
                'required' => false,
                'attr' => [
                    'placeholder' => "Ajouter un commentaire de l'intervenant",
                    'rows' => 3,
                    'class' => 'form-control form-control-solid'
                ],
            ])
            ->add('commentaireenseignant', TextareaType::class, [
                'label' => "Commentaire de l'enseignant(e)",
                'label_attr' => ['class' => 'form-label'],
                'required' => false,
                'attr' => [
                    'placeholder' => "Ajouter un commentaire de l'enseignant(e)",
                    'rows' => 3,
                    'class' => 'form-control form-control-solid'
                ],
            ])
            ->add('nbreactivites',TextType::class ,[
                'label' => "Nombre d’activités offertes par séance",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nombre d’activités offertes par séance",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
            ->add('fichesuivie', FileType::class, [
                'label' => 'Fiche suivie (PDF file)',
                'mapped' => false,
                'required' => false,
                'constraints' => [
                    new File([
                        'maxSize' => '1024k',
                        'mimeTypes' => [
                            'application/pdf',
                            'application/x-pdf',
                        ],
                        'mimeTypesMessage' => 'Please upload a valid PDF document',
                    ])
                ],
                'label_attr' => ['class' => 'form-label'],
                'attr' => [
                    'placeholder' => "Ajouter une fiche de suivie",
                    'rows' => 4,
                    'class' => 'form-control form-control-solid'
                ],
                ])
            ->add('presenceseance1',ChoiceType::class ,[
                'label' => "Présence",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Présent(e)' => 'Présent(e)',
                    'Absent(e)' => 'Absent(e)',
                    
                ],
                'attr' => [
                    'placeholder' => "Matière",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('presenceseance2',ChoiceType::class ,[
                'label' => "Présence",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
                'choices'  => [
                    'Présent(e)' => 'Présent(e)',
                    'Absent(e)' => 'Absent(e)',
                    
                ],
                'attr' => [
                    'placeholder' => "Matière",
                    'class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
            ])
            ->add('commentaireintervenant2', TextareaType::class, [
                'label' => "Commentaire de l'intervenant(e)",
                'label_attr' => ['class' => 'form-label'],
                'required' => false,
                'attr' => [
                    'placeholder' => "Ajouter un commentaire de l'intervenant(e)",
                    'rows' => 3,
                    'class' => 'form-control form-control-solid'
                ],
            ])
            ->add('commentaireenseignant2', TextareaType::class, [
                'label' => "Commentaire de l'enseignant(e)",
                'label_attr' => ['class' => 'form-label'],
                'required' => false,
                'attr' => [
                    'placeholder' => "Ajouter un commentaire de l'enseignant(e)",
                    'rows' => 3,
                    'class' => 'form-control form-control-solid'
                ],
            ])
            ->add('nbreactivites2',TextType::class ,[
                'label' => "Nombre d’activités offertes par séance",
                'label_attr' => ['class' => 'required form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Nombre d’activités offertes par séance",
                    'class'=> 'form-control form-control-solid',
                ]
                ])
                
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => SuivieEnseignement::class,
            'seance_nom' => null,
            'participantNom' => null,
        ]);
    }
}
