<?php

namespace App\Form;

use App\Entity\TrancheAge;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class TrancheAgeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('agemin',TextType::class,[
                'label' => "Âge minimum",
                'label_attr' => ['class' => 'required form-label'],
                
               
                'attr' => [
                    'placeholder' => "âge minimum",
                    'class'=> 'form-control form-control-solid',
                ]
            ])
            ->add('agemax',TextType::class,[
                'label' => "Âge maximum",
                'label_attr' => ['class' => 'required form-label'],
               
                'attr' => [
                    'placeholder' => "âge maximum",
                    'class'=> 'form-control form-control-solid',
                ]
            ]) 
            ->add('trancheage',TextType::class,[
                'label' => "Tranche d'âge",
                'label_attr' => ['class' => 'required form-label'],
               
                'attr' => [
                    'placeholder' => "Tranche d'âge",
                    'class'=> 'form-control form-control-solid',
                ]
            ]) 
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
            ])
            ->setMethod('GET','POST')
              
            ->getForm();
            
            
           
            
        }
        
    
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => TrancheAge::class,
        ]);
    }
}
