<?php

namespace App\Form;

use App\Entity\User;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\IsTrue;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;

class UsersFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('email',EmailType::class ,[
                'label' => "Email",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
               
                'attr' => [
                    'placeholder' => "Email",
                    'class'=> 'form-control form-control-lg form-control-solid',
                ]
                ])
            
            ->add('role',ChoiceType::class ,[
                'label' => "Rôles",
                'label_attr' => ['class' => 'form-label'],
                'required'   => true,
                'choices'  => [
                    'Cadre' => 'Cadre',
                    'Intervenant' => 'Intervenant',
                    'Intervenant Psychosocial' => 'Intervenant Psychosocial',
                    
                ],
                'attr' =>['class' => 'form-select form-control form-control-solid selection',
                    'data-minimum-results-for-search' => 'Infinity'
                ],
                ])
                ->add('nom',TextType::class ,[
                    'label' => "Nom de l'utilisateur",
                    'label_attr' => ['class' => 'required form-label'],
                    'required'   => true,
                
                    'attr' => [
                        'placeholder' => "Nom de l'utilisateur",
                        'class'=> 'form-control form-control-solid',
                    ]
                ])
            ->add('plainPassword', PasswordType::class, [
                // instead of being set onto the object directly,
                // this is read and encoded in the controller
                'label' => "Mot de passe",
                'mapped' => false,
                'label_attr' => ['class' => 'form-label'],
                'attr' => ['autocomplete' => 'new-password',
                    'placeholder' => "Mot de passe",
                    'class'=> 'form-control form-control-lg form-control-solid'],
                
                'constraints' => [
                    new NotBlank([
                        'message' => "Entrer un mot de passe s'il vous plait",
                    ]),
                    new Length([
                        'min' => 8,
                        'minMessage' => 'Your password should be at least {{ limit }} characters',
                        // max length allowed by Symfony for security reasons
                        'max' => 4096,
                    ]),
                ],
            ])
            ->add('Enregistrer', SubmitType::class,[
                'attr'=> [
                    'class'=> 'btn btn-primary',
            ]
                ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => User::class,
        ]);
    }
}
