<?php

namespace App\Repository;

use App\Entity\Membre;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\ORM\Query\ResultSetMappingBuilder;
/**
 * @extends ServiceEntityRepository<Membre>
 *
 * @method Membre|null find($id, $lockMode = null, $lockVersion = null)
 * @method Membre|null findOneBy(array $criteria, array $orderBy = null)
 * @method Membre[]    findAll()
 * @method Membre[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class MembreRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Membre::class);
    }

    public function save(Membre $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(Membre $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

//    /**
//     * @return Membre[] Returns an array of Membre objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('m')
//            ->andWhere('m.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('m.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?Membre
//    {
//        return $this->createQueryBuilder('m')
//            ->andWhere('m.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }



/*public function findIdSeance()
{
    // la table en base de données correspondant à l'entité liée au repository en cours
    $table = $this->getClassMetadata()->table["seance"];

    // Dans mon cas je voulais trier mes résultats avec un ordre bien particulier
    $sql =  "SELECT seance.id "
            ."FROM ".$table." AS seance "
            ."INNER JOIN session ON session.id = seance.sessions_id"
            ."INNER JOIN membre_session ON membre_session.session_id = session.id"
            ."WHERE membre_session.membre_id = :membre_id";
            //."ORDER BY m.status = :status_available DESC, m.status = :status_unknown DESC, m.status = :status_unavailable DESC, m.priority ASC";

    $rsm = new ResultSetMappingBuilder($this->getEntityManager());
    $rsm->addEntityResult(MyClass::class, "seance");

    // On mappe le nom de chaque colonne en base de données sur les attributs de nos entités
    foreach ($this->getClassMetadata()->fieldMappings as $obj) {
        $rsm->addFieldResult("seance", $obj["seance_id"], $obj["fieldName"]);
    }

    $stmt = $this->getEntityManager()->createNativeQuery($sql, $rsm);
$membre = new Membre();
    $stmt->setParameter(":membre_id", $membre->getId());
   /* $stmt->setParameter(":status_available", MyClass::STATUS_AVAILABLE);
    $stmt->setParameter(":status_unknown", MyClass::STATUS_UNKNOWN);
    $stmt->setParameter(":status_unavailable", MyClass::STATUS_UNAVAILABLE);*/

    /*$stmt->execute();

    return $stmt->getResult();
}*/

/*public function getMembreSessions($membreId) {
    return $this->getEntityManager()
                ->createQueryBuilder()
                ->select("seance.id")
                ->from('AppBundle:Seance', 'seance')
                ->innerJoin('AppBundle:Session', 'session', 'WITH', ' session.id = seance.sessions_id ')
                ->innerJoin('AppBundle:MembreSession', 'membre_session', 'WITH', ' membre_session.session_id = session.id ')
                //->leftJoin('AppBundle:Membre', 'acc', 'WITH', 'acc.id=acb.id')
                ->where("membre_session.membre_id = :membreId")
                /*->setParameters(array(
                    new Parameter('membreId', $membreId),
                ))*/
              /*  ->setParameter('membreId', $membreId)
                ->getQuery()
                //->getArrayResult();
                ->getSingleScalarResult();
}
*/
public function getLastInsertedMembreId()
{
    $queryBuilder = $this->getEntityManager()->createQueryBuilder('m')
        ->select('m.id')
        ->orderBy('m.id', 'DESC')
        ->from('App\Entity\Membre', 'm')
        ->setMaxResults(1)
        ->getQuery();

    $result = $queryBuilder->getScalarResult();
    return $result ? $result[0]['id'] : null;

    //return $result;
}
}
