<?php

namespace App\Repository;

use App\Entity\Seance;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\Query\Parameter;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Seance>
 *
 * @method Seance|null find($id, $lockMode = null, $lockVersion = null)
 * @method Seance|null findOneBy(array $criteria, array $orderBy = null)
 * @method Seance[]    findAll()
 * @method Seance[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class SeanceRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Seance::class);
    }

    public function save(Seance $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(Seance $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

//    /**
//     * @return Seance[] Returns an array of Seance objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('s')
//            ->andWhere('s.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('s.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?Seance
//    {
//        return $this->createQueryBuilder('s')
//            ->andWhere('s.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }

/*public function getMembreSessions($membreId) {
    return $this->getEntityManager()
                ->createQueryBuilder()
                ->select("seance.id")
                ->from('App\Entity\Seance', 'seance')
                ->innerJoin('App\Entity\Session', 'session', 'WITH', ' session.id = seance.sessions ')
                //->innerJoin('App\Entity\MembreSeance', 'membre_session', 'WITH', ' membre_session.session_id = session.id ')
                ->join('session.membres', 'membre_session')

                //->leftJoin('AppBundle:Membre', 'acc', 'WITH', 'acc.id=acb.id')
                ->where("membre_session.msession = :$membreId")
                ->setParameters(array(
                    new Parameter('membre_session.msession', $membreId),
                ))
                //->setParameter('membreSessionId', $membreSessionId)
                ->getQuery()
                //->getArrayResult();
                ->getSingleScalarResult();
}*/

/*public function getMembreSessions($userId)
{
    $qb = $this->createQueryBuilder('u')
        ->join('u.msession', 'g')
        ->join('g.msession', 'ug')
        ->addSelect('ug.membre_id')
        ->where('u.id = :userId')
        ->setParameter('userId', $userId);

    return $qb->getQuery()->getResult();

    /*$qb = $this->createQueryBuilder('u')
        ->join('u.msession', 'g')
        ->join('g.membres', 'ug')
        ->addSelect('ug.membre_id')
        ->where('u.id = :userId')
        ->setParameter('userId', $userId);

    return $qb->getQuery()->getResult();*/
//}

public function getMembreSessions()
{
    $qb = $this->createQueryBuilder('s');
    $qb->select('s.id')
        ->innerJoin('s.sessions', 'session')
        ->innerJoin('session.membres', 'membres')
        ->where('membres.msession = :membreId')
        ->setParameter('membreId', 43);
    
   return  $qb->getQuery()->getResult();

    /*$qb = $this->createQueryBuilder('u')
        ->join('u.msession', 'g')
        ->join('g.membres', 'ug')
        ->addSelect('ug.membre_id')
        ->where('u.id = :userId')
        ->setParameter('userId', $userId);

    return $qb->getQuery()->getResult();*/
}


}