<?php

namespace App\Repository;

use App\Entity\SuivieEnseignement;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<SuivieEnseignement>
 *
 * @method SuivieEnseignement|null find($id, $lockMode = null, $lockVersion = null)
 * @method SuivieEnseignement|null findOneBy(array $criteria, array $orderBy = null)
 * @method SuivieEnseignement[]    findAll()
 * @method SuivieEnseignement[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class SuivieEnseignementRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, SuivieEnseignement::class);
    }

    public function save(SuivieEnseignement $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(SuivieEnseignement $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

//    /**
//     * @return SuivieEnseignement[] Returns an array of SuivieEnseignement objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('s')
//            ->andWhere('s.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('s.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?SuivieEnseignement
//    {
//        return $this->createQueryBuilder('s')
//            ->andWhere('s.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
