<?php 
namespace App\Service;

use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Email;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;
use Symfony\Component\Mime\Address;

class MailerService
{
    //private MailerInterface $mailerInterface;

    public function __construct(private readonly MailerInterface $mailer){}
    public function send(
        string $to, 
        string $subject, 
        string $templateTwig, 
        array $context): void
    {
        $email = (new TemplatedEmail())
            //->from(new Address('cardsmartegy.test@gmail.com', 'cardsmartegy'))
            ->from('cardsmartegy.test@gmail.com')
            ->to($to)
            ->subject($subject)
            ->htmlTemplate("mails/$templateTwig")
            ->context($context);

        try{
            $this->mailer->send($email);
        }catch(TransportExceptionInterface $transportException){
            throw $transportException;
        }



        /*$email = (new Email())
            ->from('hello@example.com')
            ->to('you@example.com')
            //->cc('cc@example.com')
            //->bcc('bcc@example.com')
            //->replyTo('fabien@example.com')
            //->priority(Email::PRIORITY_HIGH)
            ->subject('Time for Symfony Mailer!')
            ->text('Sending emails is fun again!')
            ->html('<p>See Twig integration for better HTML integration!</p>');

        $mailer->send($email);*/

    }
}
